<x-user.content>
    <x-slot:title>eCommerce MM</x-slot:title>
    <x-slot:head> </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Checkout</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-lg-8">
                <h5 class="section-title position-relative text-uppercase mb-3"><span class="bg-secondary pr-3">Alamat
                        Pengiriman</span></h5>
                <div class="bg-light p-30 mb-5">
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Atas Nama</label>
                            <input class="form-control" type="text" placeholder="Nama..." readonly
                                value="{{ $m->nm_member }}">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>No HP / WA</label>
                            <input class="form-control" type="text" placeholder="+62..." value="{{ $m->hp_member }}"
                                readonly>
                        </div>

                        <div class="col-md-12 form-group">
                            <label> Alamat Pengiriman</label>
                            <div class="card p-3">
                                @empty(ongkir($m->id)->alamat)
                                    <div class="text-center">
                                        <h1 class="text-danger">Alamat Anda belum terdaftar..</h1>
                                    </div>
                                @else
                                    {{ ongkir($m->id)->alamat }}
                                @endempty
                            </div>

                        </div>



                        @empty(ongkir($m->id)->alamat)
                            <div class="col-md-12">
                                <div class="alert alert-warning">
                                    <strong>Perhatian :</strong> <br> Jika alamat anda belum terdaftar, silahkan ajukan
                                    terlebih dahulu.
                                </div>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="shipto">
                                    <label class="custom-control-label" for="shipto" data-toggle="collapse"
                                        data-target="#shipping-address">Ajukan alamat baru!</label>
                                </div>
                            </div>
                        @endempty
                    </div>
                </div>

                <div class="collapse mb-5" id="shipping-address">
                    <h5 class="section-title position-relative text-uppercase mb-3"><span
                            class="bg-secondary pr-3">Alamat</span></h5>
                    <div class="bg-light p-30">
                        <form action="">
                            <div class="row">
                                <div class="col-md-12 form-group">
                                    <label>Alamat Lengkap : Nama jalan, Gang / Perumahan Dll</label>
                                    <textarea name="" id="" cols="30" class="form-control" rows="9"></textarea>
                                </div>
                                <button class="btn btn-block btn-primary font-weight-bold py-3">Kirim Alamat
                                    Baru</button>
                            </div>
                        </form>
                    </div>
                </div>


            </div>


            <div class="col-lg-4">
                <h5 class="section-title position-relative text-uppercase mb-3"><span class="bg-secondary pr-3">Total
                        Pesanan
                    </span></h5>
                <div class="bg-light p-30 mb-5">
                    <div class="border-bottom">
                        <h6 class="mb-3">Item</h6>
                        @foreach (Cart::content() as $row)
                            <div class="d-flex justify-content-between">
                                <p>{{ substr($row->name, 0, 20) }}... ({{ $row->qty }})</p>
                                <p>{{ number_format($row->price * $row->qty, 0, ',', '.') }}.00</p>
                            </div>
                        @endforeach
                    </div>
                    <div class="border-bottom pt-3 pb-2">
                        <div class="d-flex justify-content-between mb-3">
                            <h6>Subtotal</h6>
                            <h6>{{ Cart::subtotal() }}</h6>
                        </div>

                        @if (diskon() != 0)
                            <div class="d-flex justify-content-between mb-3">
                                <h6>Diskon</h6>
                                <h6>{{ diskon() }}%</h6>
                            </div>
                        @endif
                        @if (ongkir($m->id)->sts_alamat == 'Y')
                            <div class="custom-control custom-radio mt-5 mb-5">
                                <span class="mr-5" style="margin-right: 85px !important; ">
                                    <input type="radio" class="custom-control-input ambil" id="antar"
                                        name="ongkir" value="Y" checked>
                                    <label class="custom-control-label " for="antar">Diantar</label>
                                </span>
                                <span>
                                    <input type="radio" class="custom-control-input ambil" id="ambil"
                                        name="ongkir" value="N">
                                    <label class="custom-control-label" for="ambil">Ambil Sendiri</label>
                                </span>
                            </div>

                            <div class="d-flex justify-content-between">
                                <h6 class="font-weight-medium">Ongkir</h6>
                                <h6 class="font-weight-medium" id="vongkir">
                                    {{ number_format($data['ongkir'], 0, ',', '.') }}.00</h6>
                            </div>
                        @endif
                    </div>
                    <div class="pt-2">
                        <div class="d-flex justify-content-between mt-2">
                            <h5>Total</h5>
                            <h5 id="total"> {{ number_format($data['ttl'], 0, ',', '.') }}.00</h5>
                        </div>
                    </div>
                    @if (modull('POIN')->isi != 0)
                        Poin Belanaja : {{ $data['poin'] }}
                    @endif
                </div>



                <div class="mb-5">
                    <h5 class="section-title position-relative text-uppercase mb-3"><span class="bg-secondary pr-3">
                            Via
                            Pembayaran</span></h5>
                    <div class="bg-light p-30">
                        @forelse ($bank as $v)
                            <div class="form-group">
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input via" name="via"
                                        id="v{{ $v->id }}" value="{{ $v->id }}">
                                    <label class="custom-control-label"
                                        for="v{{ $v->id }}">{{ $v->judul }}</label>
                                </div>
                            </div>
                        @empty
                        @endforelse
                        <hr>
                        <form action="{{ route('kirim.pesanan') }}" method="post">
                            @csrf
                            <input type="hidden" name="ongkirhid" id="ongkirhid" value="{{ $data['ongkir'] }}">
                            <input type="hidden" name="poinhid" id="poinhid" value="{{ $data['poin'] }}">
                            <input type="hidden" name="subtotal" id="subtotal" value="{{ $data['subtotal'] }}">

                            <input type="hidden" name="stsongkir" id="stsongkir" value="Y">
                            <input type="hidden" name="via_tranfer" id="via" value="0">

                            <input type="hidden" name="ttl_ongkir" id="ttl_ongkir" value="{{ $data['ttl'] }}">
                            <input type="hidden" name="ttlasli" id="ttlasli" value="{{ $data['ttlasli'] }}">
                            <button class="btn btn-block btn-danger font-weight-bold py-3 kirim" disabled>Kirim
                                Pesanan</button>
                        </form>
                        <br>
                        <a href="/list-produk" class="btn btn-block btn-primary font-weight-bold my-3 py-3">Belanja
                            Lagi</a>
                    </div>
                </div>


            </div>
        </div>
    </div>


    {{-- <div class="container vh-100"></div> --}}
    <x-slot:foot>
        <script>
            $('.ambil').click(function() {
                var ttlonk = $('#ttl_ongkir').val();
                var ttlasli = $('#ttlasli').val();
                var ongkirhid = $('#ongkirhid').val();
                var cek = $(this).val();
                if (cek == 'N') {
                    $('#stsongkir').val('N');
                    $(this).prop('checked', true);

                    var rupiah = (ttlasli / 1000).toFixed(3);
                    $("#total").html(rupiah + '.00');
                    $('#vongkir').html('0');

                } else {
                    $(this).prop('checked', true);
                    $('#stsongkir').val('Y');

                    var rupiah = (ttlonk / 1000).toFixed(3);
                    $("#total").html(rupiah + '.00');
                    var rupiah2 = (ongkirhid / 1000).toFixed(3);
                    $('#vongkir').html(rupiah2 + '.00');

                }
            })

            $('.via').click(function() {
                if ($(this).prop('checked', true)) {
                    $('#via').val($(this).val());
                    buttond()
                }

            })

            function buttond() {
                var cek = $('#via').val();
                if (cek != 0) {
                    $('.kirim').prop('disabled', false);
                } else {
                    $('.kirim').prop('disabled', true);
                }
            }
        </script>
    </x-slot:foot>
</x-user.content>
